//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Security;
using System.Security.Permissions;
using System.Text;

namespace CLRUnleashed
{
	/// <summary>
	/// Podsumowanie dla CustomPermission.
	/// </summary>
	[Serializable()]
	public class CustomPermission: CodeAccessPermission , IUnrestrictedPermission
	{
		private bool unrestricted;

		public CustomPermission(PermissionState state)
		{
			if(state == PermissionState.Unrestricted)
			{
				unrestricted = true;
			}
			else
			{
				unrestricted = false;
			}
		}
      
		public bool IsUnrestricted()
		{
			return unrestricted;
		}

		public override IPermission Copy()
		{
			//Utworzenie nowego egzemplarza CustomPermission z aktualn wartoci
			//unrestricted.
			CustomPermission copy = new CustomPermission(PermissionState.None);

			if(this.IsUnrestricted())
			{
				copy.unrestricted = true;
			}
			else
			{
				copy.unrestricted = false;
			}
			//Zwrcenie kopii.
			return copy;
		}

		public override IPermission Intersect(IPermission target)
		{
			//Zwrcenie pustej wartoci, jeli nic nie zostao zwrcone.
			if(null == target)
			{
				return null;
			}
			try
			{
				//Utworzenie nowego egzemplarza CustomPermission na podstawie przekazanego obiektu.
				CustomPermission PassedPermission = (CustomPermission)target;

				//Jeli dla jednej z klas warto unrestricted to fasz, 
				//to przecicie bdzie miao rwnie tak warto.
				//Zwrcenie przekazanej klasy z unrestricted zawierajcym fasz.
				if(!PassedPermission.unrestricted)
				{
					return target;
				}
				//Zwrcenie kopii biecej klasy, jeli przekazana warto
				//unrestricted to prawda.
				return this.Copy();
			}
				//Przechwycenie wyjtku InvalidCastException.
				//Zgoszenie ArgumentException w celu powiadomienia uytkownika.
			catch (InvalidCastException)
			{
				throw new ArgumentException("Argument_WrongType", this.GetType().FullName);
			}                
		}

		public override bool IsSubsetOf(IPermission target)
		{
			//Jeli nic nie przekazano, a unrestricted ma warto faszu,
			//to naley zwrci prawd. 
			if(null == target)
			{
				return !this.unrestricted;
			}
			try
			{        
				//Create a new instance of CustomPermission from the passed object.
				CustomPermission passedpermission = (CustomPermission)target;

				//If unrestricted has the same value in both objects, then
				//one is the subset of the other.
				if(this.unrestricted == passedpermission.unrestricted)
				{
					return true;
				}
				else
				{
					return false;
				} 
			}
				//Przechwycenie wyjtku InvalidCastException.
				//Zgoszenie ArgumentException w celu powiadomienia uytkownika.
			catch (InvalidCastException)
			{
				throw new ArgumentException("Argument_WrongType", this.GetType().FullName);
			}                    
		}

		public override void FromXml(SecurityElement PassedElement)
		{
			//Uzyskanie wartoci unrestricted z pliku XML oraz inicjalizacja 
			//biecego egzemplarza unrestricted na t warto.
			string element = PassedElement.Attribute("Unrestricted");         
 
			if(null != element)
			{  
				this.unrestricted = Convert.ToBoolean(element);
			}
		}

		public override SecurityElement ToXml()
		{
			//Zakodowanie aktualnego uprawnienia do pliku XML przy uyciu 
			//klasy elementu zabezpiecze.
			SecurityElement element = new SecurityElement("IPermission");
			Type type = this.GetType();
			StringBuilder AssemblyName = new StringBuilder(type.Assembly.ToString());
			AssemblyName.Replace('\"', '\'');
			element.AddAttribute("class", type.FullName + ", " + AssemblyName);
			element.AddAttribute("version", "1");
			element.AddAttribute("Unrestricted", unrestricted.ToString());
			return element;
		}
	}
	[AttributeUsageAttribute(AttributeTargets.All, AllowMultiple = true)]
	public class CustomPermissionAttribute: CodeAccessSecurityAttribute
	{
		bool unrestricted = false;

		public new bool Unrestricted
		{
			get{ return unrestricted; }
			set{ unrestricted = value; }
		}

		public CustomPermissionAttribute(SecurityAction action): base (action)
		{  
		}
		public override IPermission CreatePermission()
		{
			if(Unrestricted)
			{
				return new CustomPermission(PermissionState.Unrestricted);
			}
			else
			{
				return new CustomPermission(PermissionState.None);
			}
		}
	}
}
